/*
 * Decompiled with CFR 0.152.
 */
package com.kokosys.pdf;

import com.kokosys.pdf.PDFFileBean;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.io.MemoryUsageSetting;
import org.apache.pdfbox.multipdf.PDFMergerUtility;
import org.apache.pdfbox.multipdf.Splitter;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;

public class PDFTools {
    private SimpleDateFormat sdfLog = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:S");
    private List<PDFFileBean> files = new ArrayList<PDFFileBean>();

    public void addFiles(List<PDFFileBean> list) {
        this.files = list;
    }

    public String mergePDFIntercalado(String pathDestino) throws Exception {
        ArrayList<File> tmpFiles = new ArrayList<File>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hhmmss");
        String fileDestino = "Renombrame-" + sdf.format(new Date()) + ".pdf";
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        File destino = new File(pathDestino, fileDestino);
        pdfMerger.setDestinationFileName(destino.getAbsolutePath());
        int maxSizePage = 0;
        for (int f = 0; f < this.files.size(); ++f) {
            if (this.files.get(f).getPages() <= maxSizePage) continue;
            maxSizePage = this.files.get(f).getPages();
        }
        System.out.println(this.sdfLog.format(new Date()) + "[mergePDFIntercalado] paginas maximas: " + maxSizePage);
        for (int currentPage = 0; currentPage < maxSizePage; ++currentPage) {
            for (int file = 0; file < this.files.size(); ++file) {
                int finalPage;
                int n = finalPage = !this.files.get(file).isIncludeFrontPage() ? currentPage : currentPage + 1;
                if (finalPage >= this.files.get(file).getPages()) continue;
                File fcurrent = this.files.get(file).getFile();
                File tmp = new File(pathDestino, "tmp_pdf_tools_" + finalPage + "_" + fcurrent.getName());
                System.out.println(this.sdfLog.format(new Date()) + "[mergePDFIntercalado] File: " + fcurrent.getName() + " Size: " + this.files.get(file).getPages() + " Pagina: " + finalPage);
                if (finalPage == 0) {
                    this.saveFirstPage(this.files.get(file).getFile(), tmp);
                    pdfMerger.addSource(tmp);
                    tmpFiles.add(tmp);
                    continue;
                }
                PDDocument document = new PDDocument();
                document.addPage(Loader.loadPDF(fcurrent).getPage(finalPage));
                document.save(tmp);
                document.close();
                pdfMerger.addSource(tmp);
                tmpFiles.add(tmp);
            }
        }
        pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        this.removeTmpFiles(tmpFiles);
        System.out.println(this.sdfLog.format(new Date()) + "[mergePDFIntercalado]Archivo procesado, total paginas: " + tmpFiles.size());
        return destino.getAbsolutePath();
    }

    private void saveFirstPage(File file, File destino) {
        try {
            PDDocument origenFile = Loader.loadPDF(file);
            origenFile.setAllSecurityToBeRemoved(true);
            int numeroPaginas = origenFile.getNumberOfPages();
            for (int p = numeroPaginas - 1; p > 0; --p) {
                origenFile.removePage(p);
            }
            origenFile.save(destino);
            origenFile.close();
        }
        catch (Exception e) {
            System.out.println(this.sdfLog.format(new Date()) + "[saveFirstPage] Error al borra paginas del archivo: " + file.getAbsolutePath() + " | error: " + e);
        }
    }

    public String fullMerge(String pathDestino) throws Exception {
        ArrayList tmpFiles = new ArrayList();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hhmmss");
        String fileDestino = "Renombrame-" + sdf.format(new Date()) + ".pdf";
        File destino = new File(pathDestino, fileDestino);
        PDFMergerUtility PDFmerger = new PDFMergerUtility();
        PDFmerger.setDestinationFileName(destino.getAbsolutePath());
        for (PDFFileBean fb : this.files) {
            if (!fb.isIncludeFile()) continue;
            PDFmerger.addSource(fb.getFile());
        }
        PDFmerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        System.out.println(this.sdfLog.format(new Date()) + "[fullMerge]Archivo procesado, total archivos unidos: " + this.files.size());
        return destino.getAbsolutePath();
    }

    private void removeTmpFiles(List<File> tmpFiles) {
        for (File f : tmpFiles) {
            f.delete();
        }
        System.out.println(this.sdfLog.format(new Date()) + "[removeTmpFiles]Temporales: " + tmpFiles.size());
    }

    public String quitarHojas(String pathDestino) throws Exception {
        ArrayList<File> tmpFiles = new ArrayList<File>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hhmmss");
        String fileDestino = "Renombrame-" + sdf.format(new Date()) + ".pdf";
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        File destino = new File(pathDestino, fileDestino);
        pdfMerger.setDestinationFileName(destino.getAbsolutePath());
        for (int file = 0; file < this.files.size(); ++file) {
            PDFFileBean bean = this.files.get(file);
            File fcurrent = bean.getFile();
            for (int currentPage = 0; currentPage < bean.getPages(); ++currentPage) {
                if (this.isInConfiguration(bean.getConfiguration(), currentPage)) continue;
                File tmp = new File(pathDestino, "tmp_pdf_tools_" + currentPage + "_" + fcurrent.getName());
                System.out.println(this.sdfLog.format(new Date()) + "[quitarHojas] File: " + fcurrent.getName() + " Size: " + this.files.get(file).getPages() + " Pagina: " + currentPage);
                if (currentPage == 0) {
                    this.saveFirstPage(this.files.get(file).getFile(), tmp);
                    pdfMerger.addSource(tmp);
                    tmpFiles.add(tmp);
                    continue;
                }
                PDDocument document = new PDDocument();
                document.addPage(Loader.loadPDF(fcurrent).getPage(currentPage));
                document.save(tmp);
                document.close();
                pdfMerger.addSource(tmp);
                tmpFiles.add(tmp);
            }
        }
        pdfMerger.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        this.removeTmpFiles(tmpFiles);
        System.out.println(this.sdfLog.format(new Date()) + "[quitarHojas]Archivo procesado, total paginas: " + tmpFiles.size());
        return destino.getAbsolutePath();
    }

    private boolean isInConfiguration(String[] configuration, int currentPage) {
        boolean result = false;
        for (String c : configuration) {
            if (currentPage + 1 != Integer.parseInt(c)) continue;
            result = true;
        }
        return result;
    }

    public String mergeManual(String pathDestino) throws Exception {
        ArrayList<File> tmpFiles = new ArrayList<File>();
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd_hhmmss");
        String fileDestino = "Renombrame-" + sdf.format(new Date()) + ".pdf";
        PDFMergerUtility pdfMerger = new PDFMergerUtility();
        File destino = new File(pathDestino, fileDestino);
        pdfMerger.setDestinationFileName(destino.getAbsolutePath());
        for (int file = 0; file < this.files.size(); ++file) {
            PDFFileBean bean = this.files.get(file);
            File fcurrent = bean.getFile();
            for (String userconfigurationPage : bean.getConfiguration()) {
                File tmp = new File(pathDestino, "tmp_pdf_tools_" + userconfigurationPage + "_" + fcurrent.getName());
                System.out.println(this.sdfLog.format(new Date()) + "[mergeManual] File: " + fcurrent.getName() + " Size: " + bean.getPages() + " Pagina: " + userconfigurationPage);
                this.getSpecificPage(fcurrent, tmp, Integer.parseInt(userconfigurationPage));
                pdfMerger.addSource(tmp);
                tmpFiles.add(tmp);
            }
        }
        System.out.println(this.sdfLog.format(new Date()) + "[mergeManual] inicia merge ");
        pdfMerger.setDocumentMergeMode(PDFMergerUtility.DocumentMergeMode.OPTIMIZE_RESOURCES_MODE);
        pdfMerger.mergeDocuments(MemoryUsageSetting.setupMainMemoryOnly());
        System.out.println(this.sdfLog.format(new Date()) + "[mergeManual] finaliza merge ");
        this.removeTmpFiles(tmpFiles);
        System.out.println(this.sdfLog.format(new Date()) + "[mergeManual]Archivo procesado, total paginas: " + tmpFiles.size());
        return destino.getAbsolutePath();
    }

    public void getSpecificPage(File file, File destino, int userPageNumber) {
        try {
            PDDocument origenFile = Loader.loadPDF(file);
            Splitter splitter = new Splitter();
            List<PDDocument> origenPages = splitter.split(origenFile);
            PDDocument auxiliar = origenFile;
            auxiliar.setAllSecurityToBeRemoved(true);
            for (int i = auxiliar.getNumberOfPages() - 1; i >= 0; --i) {
                auxiliar.removePage(i);
            }
            int p = 0;
            for (PDDocument currenPage : origenPages) {
                if (p == userPageNumber - 1) {
                    PDDocument hoja = auxiliar;
                    PDPage tmpPage = currenPage.getPage(0);
                    hoja.addPage(tmpPage);
                    hoja.save(destino);
                    hoja.close();
                }
                ++p;
            }
            auxiliar.close();
            origenFile.close();
        }
        catch (Exception e) {
            System.out.println(this.sdfLog.format(new Date()) + "[createUniquePage][" + userPageNumber + "] Error al borrar paginas del archivo: " + file.getAbsolutePath() + " | error: " + e);
        }
    }

    private void createUniquePage(File file, File destino, int userPageNumber) {
        try {
            int p;
            PDDocument origenFile = Loader.loadPDF(file);
            origenFile.setAllSecurityToBeRemoved(true);
            int numeroPaginas = origenFile.getNumberOfPages();
            System.out.println(this.sdfLog.format(new Date()) + "[createUniquePage][" + userPageNumber + "] ");
            for (p = numeroPaginas - 1; p > userPageNumber - 1; --p) {
                origenFile.removePage(p);
            }
            p = 0;
            while (origenFile.getNumberOfPages() > 1) {
                origenFile.removePage(0);
            }
            origenFile.save(destino);
            origenFile.close();
        }
        catch (Exception e) {
            System.out.println(this.sdfLog.format(new Date()) + "[createUniquePage][" + userPageNumber + "] Error al borrar paginas del archivo: " + file.getAbsolutePath() + " | error: " + e);
        }
    }
}

