/*
 * Decompiled with CFR 0.152.
 */
package com.kokosys.pdf.gui;

import com.kokosys.controllers.MenuActions;
import com.kokosys.controllers.ValidaData;
import com.kokosys.pdf.PDFFileBean;
import com.kokosys.pdf.PDFTools;
import java.awt.Color;
import java.awt.EventQueue;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.swing.DefaultComboBoxModel;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JOptionPane;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.filechooser.FileNameExtensionFilter;
import javax.swing.table.DefaultTableModel;

public class PDFToolGui
extends JFrame {
    private DefaultTableModel model;
    private SimpleDateFormat sdf = new SimpleDateFormat("dd-MM-yyyy HH:mm:ss:S");
    private JButton btnAddFile;
    private JButton btnMerge;
    private JButton btnPathDestino;
    private JComboBox<String> comboMergeType;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JLabel jLabel7;
    private JMenuBar jMenuBar1;
    private JScrollPane jScrollPane1;
    private JMenu menuAcercaDe;
    private JMenu menuHelp;
    private JTable tableFiles;
    private JTextField txtPathDestino;

    public PDFToolGui() {
        this.initComponents();
        ImageIcon icon = new ImageIcon(this.getClass().getClassLoader().getResource("logo.png"));
        this.setIconImage(icon.getImage());
        boolean[] canEdit = new boolean[]{false, false, false, false, false, false};
        this.configureTable(canEdit);
    }

    private void initComponents() {
        this.btnMerge = new JButton();
        this.jScrollPane1 = new JScrollPane();
        this.tableFiles = new JTable();
        this.btnAddFile = new JButton();
        this.txtPathDestino = new JTextField();
        this.btnPathDestino = new JButton();
        this.jLabel1 = new JLabel();
        this.comboMergeType = new JComboBox();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.jLabel6 = new JLabel();
        this.jLabel7 = new JLabel();
        this.jMenuBar1 = new JMenuBar();
        this.menuHelp = new JMenu();
        this.menuAcercaDe = new JMenu();
        this.setDefaultCloseOperation(3);
        this.setTitle("PDFTools Desktop");
        this.btnMerge.setText("Procesar PDF");
        this.btnMerge.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PDFToolGui.this.btnMergeMouseClicked(evt);
            }
        });
        this.tableFiles.setModel(new DefaultTableModel(new Object[0][], new String[0]));
        this.jScrollPane1.setViewportView(this.tableFiles);
        this.btnAddFile.setText("Agregar archivo");
        this.btnAddFile.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PDFToolGui.this.btnAddFileMouseClicked(evt);
            }
        });
        this.btnPathDestino.setText("Seleccionar");
        this.btnPathDestino.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PDFToolGui.this.btnPathDestinoMouseClicked(evt);
            }
        });
        this.jLabel1.setFont(new Font("Arial", 0, 12));
        this.jLabel1.setText("Modo de procesamiento");
        this.comboMergeType.setModel(new DefaultComboBoxModel<String>(new String[]{"---Selecciona un modo---", "Archivos completos", "Intercalar hojas", "Quitar hojas", "Manual"}));
        this.comboMergeType.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent evt) {
                PDFToolGui.this.comboMergeTypeActionPerformed(evt);
            }
        });
        this.jLabel2.setFont(new Font("Arial", 0, 12));
        this.jLabel2.setText("Carpeta destino:");
        this.jLabel3.setBackground(new Color(0, 0, 255));
        this.jLabel3.setFont(new Font("Segoe UI", 3, 12));
        this.jLabel3.setText("1");
        this.jLabel4.setBackground(new Color(0, 0, 255));
        this.jLabel4.setFont(new Font("Segoe UI", 3, 12));
        this.jLabel4.setText("2");
        this.jLabel5.setBackground(new Color(0, 0, 255));
        this.jLabel5.setFont(new Font("Segoe UI", 3, 12));
        this.jLabel5.setText("3");
        this.jLabel6.setBackground(new Color(0, 0, 255));
        this.jLabel6.setFont(new Font("Segoe UI", 3, 12));
        this.jLabel6.setText("5");
        this.jLabel7.setBackground(new Color(0, 0, 255));
        this.jLabel7.setFont(new Font("Segoe UI", 3, 12));
        this.jLabel7.setText("4");
        this.menuHelp.setText("Ayuda");
        this.menuHelp.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PDFToolGui.this.menuHelpMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuHelp);
        this.menuAcercaDe.setText("Acerca de");
        this.menuAcercaDe.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent evt) {
                PDFToolGui.this.menuAcercaDeMouseClicked(evt);
            }
        });
        this.jMenuBar1.add(this.menuAcercaDe);
        this.setJMenuBar(this.jMenuBar1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(this.jLabel2, -2, 98, -2).addComponent(this.jLabel1)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.comboMergeType, -2, 169, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4, -2, 14, -2)).addGroup(layout.createSequentialGroup().addComponent(this.txtPathDestino, -2, 281, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.btnPathDestino).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel3, -2, 14, -2))).addGap(0, 223, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.btnMerge).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(this.jLabel6, -2, 14, -2).addGap(35, 35, 35)).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1).addContainerGap()).addGroup(layout.createSequentialGroup().addComponent(this.btnAddFile).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5, -2, 14, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.jLabel7, -2, 14, -2).addGap(127, 127, 127)))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(8, 8, 8).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.txtPathDestino, -2, -1, -2).addComponent(this.btnPathDestino).addComponent(this.jLabel2).addComponent(this.jLabel3)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.comboMergeType, -2, -1, -2).addComponent(this.jLabel1).addComponent(this.jLabel4)).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnAddFile).addComponent(this.jLabel5).addComponent(this.jLabel7)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -2, 171, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, 33, Short.MAX_VALUE).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.btnMerge).addComponent(this.jLabel6)).addGap(19, 19, 19)));
        this.pack();
    }

    public void configureTable(final boolean[] columnEdit) {
        this.model = new DefaultTableModel(new Object[0][], new String[]{"Archivo", "P\u00e1ginas", "Excluir portada", "Todo", "Configuraci\u00f3n", "Incluir"}){
            Class[] types;
            public boolean[] canEdit;
            {
                super(arg0, arg1);
                this.types = new Class[]{String.class, String.class, Boolean.class, Boolean.class, String.class, Boolean.class};
                this.canEdit = columnEdit;
            }

            public Class getColumnClass(int columnIndex) {
                return this.types[columnIndex];
            }

            @Override
            public boolean isCellEditable(int rowIndex, int columnIndex) {
                return this.canEdit[columnIndex];
            }
        };
        this.tableFiles.setModel(this.model);
        if (this.tableFiles.getColumnModel().getColumnCount() > 0) {
            this.tableFiles.getColumnModel().getColumn(0).setPreferredWidth(400);
            this.tableFiles.getColumnModel().getColumn(1).setResizable(false);
            this.tableFiles.getColumnModel().getColumn(1).setPreferredWidth(60);
            this.tableFiles.getColumnModel().getColumn(2).setResizable(false);
            this.tableFiles.getColumnModel().getColumn(2).setPreferredWidth(95);
            this.tableFiles.getColumnModel().getColumn(3).setResizable(false);
            this.tableFiles.getColumnModel().getColumn(3).setPreferredWidth(40);
            this.tableFiles.getColumnModel().getColumn(4).setResizable(true);
            this.tableFiles.getColumnModel().getColumn(4).setPreferredWidth(100);
            this.tableFiles.getColumnModel().getColumn(5).setResizable(false);
            this.tableFiles.getColumnModel().getColumn(5).setPreferredWidth(50);
        }
        System.out.println(this.sdf.format(new Date()) + "[Tabla construida]");
    }

    private void btnMergeMouseClicked(MouseEvent evt) {
        String pathDestino = this.txtPathDestino.getText();
        int selectedIndex = this.comboMergeType.getSelectedIndex();
        if (pathDestino.isEmpty() || !new File(pathDestino).isDirectory()) {
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked]Seleccione una ruta destino valida por favor.");
            JOptionPane.showMessageDialog(this, "Seleccione una ruta destino valida por favor", "PDFTools Desktop", 2);
            return;
        }
        if (selectedIndex == 0) {
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked]Seleccione un modo de procesamiento.");
            JOptionPane.showMessageDialog(this, "Seleccione un modo de procesamiento", "PDFTools Desktop", 2);
            return;
        }
        if (this.tableFiles.getRowCount() < 1) {
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked]Debe agregar por lo menos un archivo");
            JOptionPane.showMessageDialog(this, "Debe agregar por lo menos un archivo", "PDFTools Desktop", 2);
            return;
        }
        if (this.tableFiles.getCellEditor() != null) {
            this.tableFiles.getCellEditor().stopCellEditing();
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked]Cerrando el editor para realizar merge");
        }
        try {
            String fDest = null;
            PDFTools pdf = new PDFTools();
            List<PDFFileBean> list = this.getValuesTable();
            pdf.addFiles(list);
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked]Data recuperada: " + list.size());
            switch (selectedIndex) {
                case 1: {
                    if (list.size() < 2) {
                        System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Archivos completos]Debe agregar por lo menos dos archivos para utilizar este modo de procesamiento");
                        JOptionPane.showMessageDialog(this, "Debe agregar por lo menos dos archivos para utilizar este modo de procesamiento", "PDFTools Desktop", 0);
                        return;
                    }
                    fDest = pdf.fullMerge(pathDestino);
                    break;
                }
                case 2: {
                    if (list.size() < 2) {
                        System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Intercalar holas]Debe agregar por lo menos dos archivos para utilizar este modo de procesamiento");
                        JOptionPane.showMessageDialog(this, "Debe agregar por lo menos dos archivos para utilizar este modo de procesamiento", "PDFTools Desktop", 0);
                        return;
                    }
                    fDest = pdf.mergePDFIntercalado(pathDestino);
                    break;
                }
                case 3: {
                    if (list.size() < 1) {
                        System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Quitar hojas]Debe agregar por lo menos un archivos para utilizar este modo de procesamiento");
                        JOptionPane.showMessageDialog(this, "Debe agregar por lo menos un archivos para utilizar este modo de procesamiento", "PDFTools Desktop", 0);
                        return;
                    }
                    for (PDFFileBean bean : list) {
                        if (bean.getConfiguration() == null || bean.getConfiguration().length < 1) {
                            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Quitar hojas]Debe agregar las p\u00e1ginas en la columna Configuraci\u00f3n. Archivo: " + bean.getFile().getAbsolutePath());
                            JOptionPane.showMessageDialog(this, "Debe agregar las p\u00e1ginas en la columna Configuraci\u00f3n. \nArchivo: " + bean.getFile().getAbsolutePath(), "PDFTools Desktop", 0);
                            return;
                        }
                        if (ValidaData.isValidNumberPages(bean.getConfiguration(), bean.getPages())) continue;
                        JOptionPane.showMessageDialog(this, "La configuraci\u00f3n de p\u00e1ginas no es valida. Comprueba que no sea 0 o mayor al n\u00famero de paginas total del documento:\n" + bean.getFile().getAbsolutePath(), "PDFTools Desktop", 0);
                        return;
                    }
                    fDest = pdf.quitarHojas(pathDestino);
                    break;
                }
                case 4: {
                    if (list.size() < 1) {
                        System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Manual]Debe agregar por lo menos un archivos para utilizar este modo de procesamiento");
                        JOptionPane.showMessageDialog(this, "Debe agregar por lo menos un archivos para utilizar este modo de procesamiento", "PDFTools Desktop", 0);
                        return;
                    }
                    for (PDFFileBean bean : list) {
                        if (bean.getConfiguration() == null || bean.getConfiguration().length < 1) {
                            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked Manual]Debe agregar las p\u00e1ginas en la columna Configuraci\u00f3n. Archivo: " + bean.getFile().getAbsolutePath());
                            JOptionPane.showMessageDialog(this, "Debe agregar las p\u00e1ginas en la columna Configuraci\u00f3n. \nArchivo: " + bean.getFile().getAbsolutePath(), "PDFTools Desktop", 0);
                            return;
                        }
                        if (ValidaData.isValidNumberPages(bean.getConfiguration(), bean.getPages())) continue;
                        JOptionPane.showMessageDialog(this, "La configuraci\u00f3n de p\u00e1ginas no es valida. Comprueba que no sea 0 o mayor al n\u00famero de paginas total del documento:\n" + bean.getFile().getAbsolutePath(), "PDFTools Desktop", 0);
                        return;
                    }
                    fDest = pdf.mergeManual(pathDestino);
                    break;
                }
                default: {
                    System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked default]Seleccione un modo de procesamiento");
                    JOptionPane.showMessageDialog(this, "Seleccione un modo de procesamiento", "PDFTools Desktop", 2);
                }
            }
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked fDest] " + fDest);
            if (fDest != null) {
                JOptionPane.showMessageDialog(this, "Se genero el archivo: " + fDest, "PDFTools Desktop", 1);
            }
        }
        catch (Exception e) {
            System.out.println(this.sdf.format(new Date()) + "[btnMergeMouseClicked] Error:" + e);
            JOptionPane.showMessageDialog(this, "Error: " + e, "PDFTools Desktop", 0);
        }
    }

    private void btnAddFileMouseClicked(MouseEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileFilter(new FileNameExtensionFilter("PDF Files and Images", "PDF", "JPEG", "PNG"));
        if (jfc.showOpenDialog(this) == 0) {
            System.out.println(this.sdf.format(new Date()) + "[btnAddFileMouseClicked] " + jfc.getSelectedFile().getAbsolutePath());
            try {
                boolean fullFile = this.comboMergeType.getSelectedIndex() == 1;
                PDFFileBean f = new PDFFileBean(jfc.getSelectedFile(), fullFile, false, null, true);
                this.model.addRow(new Object[]{f.getFile().getAbsolutePath(), f.getPages(), f.isIncludeFrontPage(), f.isIncludeFullfile(), f.getConfiguration(), f.isIncludeFile()});
                System.out.println(this.sdf.format(new Date()) + "[btnAddFileMouseClicked] " + f.getFile().getAbsolutePath() + "|" + f.getPages() + "|" + f.isIncludeFrontPage() + "|" + f.isIncludeFullfile() + "|" + f.getConfiguration() + "|" + f.isIncludeFile());
            }
            catch (Exception e) {
                System.out.println(this.sdf.format(new Date()) + "[btnAddFileMouseClicked] Error:" + e);
                JOptionPane.showMessageDialog(this, "Error(intente cargando nuevamente el archivo u otro diferente): " + e, "Error al cargar archivo", 0);
            }
        }
    }

    private void btnPathDestinoMouseClicked(MouseEvent evt) {
        JFileChooser jfc = new JFileChooser();
        jfc.setFileSelectionMode(1);
        jfc.setAcceptAllFileFilterUsed(false);
        if (jfc.showOpenDialog(this) == 0) {
            this.txtPathDestino.setText(jfc.getSelectedFile().toString());
            System.out.println(this.sdf.format(new Date()) + "[btnPathDestinoMouseClicked] pathSelected:" + jfc.getSelectedFile().toString());
        }
    }

    private void comboMergeTypeActionPerformed(ActionEvent evt) {
        JComboBox combo = (JComboBox)evt.getSource();
        int selectedIndex = combo.getSelectedIndex();
        switch (selectedIndex) {
            case 0: {
                boolean[] canEdit = new boolean[]{false, false, true, false, false, true};
                this.configureTable(canEdit);
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Ningun modo");
                break;
            }
            case 1: {
                boolean[] canEdit = new boolean[]{false, false, false, false, false, true};
                this.configureTable(canEdit);
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Archivos completos");
                break;
            }
            case 2: {
                boolean[] canEdit = new boolean[]{false, false, true, false, false, true};
                this.configureTable(canEdit);
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Intercalar hojas");
                break;
            }
            case 3: {
                boolean[] canEdit = new boolean[]{false, false, false, false, true, true};
                this.configureTable(canEdit);
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Quitar hojas");
                break;
            }
            case 4: {
                boolean[] canEdit = new boolean[]{false, false, false, false, true, true};
                this.configureTable(canEdit);
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Manual");
                break;
            }
            default: {
                System.out.println(this.sdf.format(new Date()) + "[comboMergeTypeActionPerformed] combo:Default");
                JOptionPane.showMessageDialog(this, "Seleccione un modo", "PDFTools Desktop", 1);
            }
        }
    }

    private void menuHelpMouseClicked(MouseEvent evt) {
        MenuActions actions = new MenuActions();
        actions.menuHelp();
        System.out.println(this.sdf.format(new Date()) + "[menuHelpMouseClicked] Help");
    }

    private void menuAcercaDeMouseClicked(MouseEvent evt) {
        MenuActions actions = new MenuActions();
        actions.menuAcercaDe();
        System.out.println(this.sdf.format(new Date()) + "[menuAcercaDeMouseClicked] Acerca de");
    }

    private List<PDFFileBean> getValuesTable() throws Exception {
        ArrayList<PDFFileBean> list = new ArrayList<PDFFileBean>();
        int countFila = this.tableFiles.getRowCount();
        System.out.println(this.sdf.format(new Date()) + "[getValuesTable] Filas: " + countFila);
        for (int fila = 0; fila < countFila; ++fila) {
            File file = new File(this.tableFiles.getValueAt(fila, 0).toString());
            boolean includeFullFile = (Boolean)this.tableFiles.getValueAt(fila, 3);
            boolean includeFrontPage = (Boolean)this.tableFiles.getValueAt(fila, 2);
            String[] configuration = null;
            if (this.tableFiles.getValueAt(fila, 4) != null && this.tableFiles.getValueAt(fila, 4).toString().trim().length() > 0) {
                configuration = this.tableFiles.getValueAt(fila, 4).toString().trim().split(",");
            }
            boolean includeFile = (Boolean)this.tableFiles.getValueAt(fila, 5);
            PDFFileBean f = new PDFFileBean(file, includeFullFile, includeFrontPage, configuration, includeFile);
            System.out.println(this.sdf.format(new Date()) + "[getValuesTable][" + fila + "]" + file + "|" + includeFullFile + "|" + includeFrontPage + "|" + configuration + "[" + this.tableFiles.getValueAt(fila, 4) + "]|" + includeFile);
            if (!includeFile) continue;
            list.add(f);
            System.out.println(this.sdf.format(new Date()) + "[getValuesTable]Archivo agregado a la lista");
        }
        return list;
    }

    public static void main(String[] args) {
        try {
            for (UIManager.LookAndFeelInfo info : UIManager.getInstalledLookAndFeels()) {
                if (!"Nimbus".equals(info.getName())) continue;
                UIManager.setLookAndFeel(info.getClassName());
                break;
            }
        }
        catch (ClassNotFoundException ex) {
            Logger.getLogger(PDFToolGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (InstantiationException ex) {
            Logger.getLogger(PDFToolGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (IllegalAccessException ex) {
            Logger.getLogger(PDFToolGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        catch (UnsupportedLookAndFeelException ex) {
            Logger.getLogger(PDFToolGui.class.getName()).log(Level.SEVERE, null, ex);
        }
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                new PDFToolGui().setVisible(true);
            }
        });
    }
}

